#!/bin/bash
# provides funictionality to safely copy data to climstor 
# rhand@giub.unibe.ch

site=daint

case ${site} in
   daint)

      function safe_copy {
      
         # usage: safe_copy $file $desthost destdir [keep]
      
         file=$(readlink -f ${1})
         desthost=${2}
         destdir=${3}
         keep=${4}
      
         if ssh ela ssh ${desthost} [ ! -d ${destdir} ]; then
            ssh ela ssh ${desthost} mkdir --mode=755 -p ${destdir}
         fi  # destdir does not exist on desthost
      
         if [ $(du ${file} | awk '{print $1}') -ne 0 ]; then  # just to make sure, that no empty files are tried to be copied.
      
            tmp=$(ssh ela mktemp -d -p /project/s964/transfer tmp_XXX)
      
            if [ "${keep}" == "keep" ]; then
               ssh ela rsync daint:${file} ${tmp} && ssh ela rsync --remove-source-files -a ${tmp}/$(basename ${file}) ${desthost}:${destdir}/. && echo "${file} copied to ${desthost}:${destdir}/$(basename ${file}) and kept on daint."
            else
               ssh ela rsync --remove-source-files -a daint:${file} ${tmp} && 
               ssh ela rsync --remove-source-files -a ${tmp}/$(basename ${file}) ${desthost}:${destdir}/. &&
               echo "${file} copied to ${desthost}:${destdir}/$(basename ${file}) and deleted from daint." 
            fi
         
            if [ $? -ne 0 ] ; then 
               ssh ela echo "${file} to ${desthost}:${destdir} at $(date +%Y-%m-%d\ %H:%M)" >> /project/s964/transfer/failed_transfers.log
               export success=false 
            fi
      
            ssh ela rmdir ${tmp}
      
         fi # file is not empty
      
      }
 

      function ypoc_efas {

         # usage: ypoc_efas sourcehost file destdir [overwrite]

         sourcehost=${1}
         file=${2}
         destdir=$(readlink -f ${3})
         overwrite=${4}

         if [ ! -d ${destdir} ]; then
            mkdir --mode=755 -p ${destdir}
         fi  # destdir does not exist


         if $(ssh ela "ssh ${sourcehost} test -e ${file}"); then  # test if file exists on sourcehost

            if [ ! -e ${destdir}/$(basename ${file}) ] || [ "${overwrite}" == "overwrite" ]; then

               tmp=$(ssh ela mktemp -d -p /project/s964/transfer tmp_XXX)

                  ssh ela rsync ${sourcehost}:${file} ${tmp} && ssh ela rsync --remove-source-files -a ${tmp}/$(basename ${file}) daint:${destdir}/. && echo "${file} copied to ${destdir}/$(basename ${file}) and kept on ${sourcehost}."
   
               if [ $? -ne 0 ] ; then
                  ssh ela echo "${sourcehost}:${file} to ${destdir} at $(date +%Y-%m-%d\ %H:%M)" >> /project/s964/transfer/failed_transfers.log
                  export success=false
               fi
   
               ssh ela rmdir ${tmp}

            else

               echo "ERROR: file exists already on desthost. Use overwrite mode to overwrite existing file" && exit 1

            fi # file does not exist on desthost or overwrite is set
 
         else 

            echo "ERROR: file does not exist on sourcehost" && exit 1

         fi # file exists on sourcehost

      }


      ;;

   ubelix)  

      proxy="ssh submit03"

      function safe_copy {
 
         # usage: safe_copy $file $desthost destdir [keep]
 
         file=$(readlink -f ${1})
         desthost=${2}
         destdir=${3}
         keep=${4}
 
         if ${proxy} ssh ${desthost} [ ! -d ${destdir} ]; then
            ${proxy} ssh ${desthost} mkdir --mode=755 -p ${destdir}
         fi  # destdir does not exist on desthost
 
#         if [ $(du ${file} | awk '{print $1}') -ne 0 ]; then  # just to make sure, that no empty files are tried to be copied.
 
            if [ "${keep}" == "keep" ]; then
               ${proxy} rsync -a ${file} ${desthost}:${destdir}/. && echo "${file} copied to ${desthost}:${destdir}/$(basename ${file}) and kept on daint."
            else   
               ${proxy} rsync --remove-source-files -a ${file} ${desthost}:${destdir}/. && echo "${file} copied to ${desthost}:${destdir}/$(basename ${file}) and deleted from ubelix."
            fi
    
            if [ $? -ne 0 ] ; then
               echo "${file} to ${desthost}:${destdir} at $(date +%Y-%m-%d\ %H:%M)" >> ${HOME}/failed_transfers.log
               export success=false
            fi
 
#         fi # file is not empty
 
      }

      function ypoc_efas {

         # usage: ypoc_efas sourcehost file destdir [overwrite]

         sourcehost=${1}
         file=${2}
         destdir=$(readlink -f ${3})
         overwrite=${4}

         if [ ! -d ${destdir} ]; then
            mkdir --mode=755 -p ${destdir}
         fi  # destdir does not exist


         if $(ssh ela "ssh ${sourcehost} test -e ${file}"); then  # test if file exists on sourcehost

            if [ ! -e ${destdir}/$(basename ${file}) ] || [ "${overwrite}" == "overwrite" ]; then

               ${proxy} rsync ${sourcehost}:${file} ${destdir}/. && echo "${file} copied to ${destdir}/$(basename ${file}) and kept on ${sourcehost}."

               if [ $? -ne 0 ] ; then
                  echo "${sourcehost}:${file} to ${destdir} at $(date +%Y-%m-%d\ %H:%M)" >> /project/s964/transfer/failed_transfers.log
                  export success=false
               fi

            else

               echo "ERROR: file exists already on desthost. Use overwrite mode to overwrite existing file" && exit 1

            fi # file does not exist on desthost or overwrite is set

         else

            echo "ERROR: file does not exist on sourcehost" && exit 1

         fi # file exists on sourcehost

      }

      ;;

esac

