#!/bin/bash
# a quick and dirty script to rerun the postprocessing in case something failed...
# rhand@giub.unibe.ch, 2019-11-26

set -ex

case ${1} in
   rerun) rerun_prefix="rerun_"; shift ;;
   *) rerun_prefix="" ;;
esac

yearlist=$*

expname=$(pwd | sed -e "s&.*/&&")

for year in ${yearlist}; do

   sed -e "s&#DPATH&DPATH=$(pwd)/work&" -e "s/#EXP/EXP=${rerun_prefix}${expname}/" -e "s/#YEAR/YEAR=${year}/" -e "s/#MONTH/MONTH=12/" -e "s/#DAY/DAY=01/"  ${expname}.job1 > work/rerun_subjob1
   sed -e "s&#DPATH&DPATH=$(pwd)/work&" -e "s/#EXP/EXP=${rerun_prefix}${expname}/"  ${expname}.job2 > work/subjob2

   chmod 770 work/rerun_subjob1 work/subjob2

   cd work &&

   shopt -s extglob # make regex work in case statement
   case $(cat prevpostprojob.dat 2>/dev/null) in
      +([[:digit:]]) ) dependency="--dependency=afterany:$(cat prevpostprojob.dat)" ;;
      *) dependency="" ;;
   esac
	
   previousjob=$(sbatch ${dependency} rerun_subjob1 | sed -e "s/Submitted batch job //") &&
   echo "${previousjob}" > prevpostprojob.dat &&
   cd -

done
