#!/bin/bash
# provides funictionality to safely copy data to climstor 
# rhand@giub.unibe.ch

site=daint

case ${site} in
   daint)

      proxy="ssh daint"

      function safe_copy {
      
         # usage: safe_copy $file $desthost destdir [keep]
      
         file=$(readlink -f ${1})
         desthost=${2}
         destdir=${3}
         keep=${4}
      
         if ${proxy} ssh ${desthost} [ ! -d ${destdir} ]; then
            ${proxy} ssh ${desthost} mkdir --mode=755 -p ${destdir}
         fi  # destdir does not exist on desthost
      
         if [ $(du ${file} | awk '{print $1}') -ne 0 ]; then  # just to make sure, that no empty files are tried to be copied.
      
            if [ "${keep}" == "keep" ]; then
               ${proxy} rsync -a ${file} ${desthost}:${destdir}/. && echo "${file} copied to ${desthost}:${destdir}/$(basename ${file}) and kept on daint."
            else
               ${proxy} rsync --remove-source-files -a ${file} ${desthost}:${destdir}/. &&
               echo "${file} copied to ${desthost}:${destdir}/$(basename ${file}) and deleted from daint." 
            fi
         
            if [ $? -ne 0 ] ; then 
               ${proxy} echo "${file} to ${desthost}:${destdir} at $(date +%Y-%m-%d\ %H:%M)" >> failed_transfers.log && 
               echo "transfer failed. See $(readlink -f failed_transfers.log) for details."
               export success=false 
            fi

            remoteuser=$(${proxy} ssh ${desthost} "whoami")
            ${proxy} ssh ${desthost} "chown ${remoteuser}:palaeo-ra ${destdir}/$(basename ${file})" && 
            ${proxy} ssh ${desthost} "chmod 775 ${destdir}/$(basename ${file})"
  
         fi # file is not empty
      
      }
 

      function ypoc_efas {

         # usage: ypoc_efas sourcehost file destdir [overwrite]

         sourcehost=${1}
         file=${2}
         destdir=$(readlink -f ${3})
         overwrite=${4}

         if [ ! -d ${destdir} ]; then
            mkdir --mode=755 -p ${destdir}
         fi  # destdir does not exist


         if $(ssh daint "ssh ${sourcehost} test -e ${file}"); then  # test if file exists on sourcehost

            if [ ! -e ${destdir}/$(basename ${file}) ] || [ "${overwrite}" == "overwrite" ]; then

                  ${proxy} rsync ${sourcehost}:${file} ${destdir}/. && echo "${file} copied to ${destdir}/$(basename ${file}) and kept on ${sourcehost}."
   
               if [ $? -ne 0 ] ; then
                  ${proxy} echo "${sourcehost}:${file} to ${destdir} at $(date +%Y-%m-%d\ %H:%M)" >> failed_transfers.log &&
                  echo "transfer failed. See $(readlink -f failed_transfers.log) for details."
                  export success=false
               fi
   
            else

               echo "ERROR: file exists already on desthost. Use overwrite mode to overwrite existing file" && exit 1

            fi # file does not exist on desthost or overwrite is set
 
         else 

            echo "ERROR: file does not exist on sourcehost" && exit 1

         fi # file exists on sourcehost

      }


      ;;

   ubelix)  

      proxy="ssh submit02"

      function safe_copy {
 
         # usage: safe_copy $file $desthost destdir [keep]
 
         file=$(readlink -f ${1})
         desthost=${2}
         destdir=${3}
         keep=${4}
 
         if ${proxy} ssh ${desthost} [ ! -d ${destdir} ]; then
            ${proxy} ssh ${desthost} mkdir --mode=755 -p ${destdir}
         fi  # destdir does not exist on desthost
 
#         if [ $(du ${file} | awk '{print $1}') -ne 0 ]; then  # just to make sure, that no empty files are tried to be copied.
 
            if [ "${keep}" == "keep" ]; then
               ${proxy} rsync -a ${file} ${desthost}:${destdir}/. && echo "${file} copied to ${desthost}:${destdir}/$(basename ${file}) and kept on daint."
            else   
               ${proxy} rsync --remove-source-files -a ${file} ${desthost}:${destdir}/. && echo "${file} copied to ${desthost}:${destdir}/$(basename ${file}) and deleted from ubelix."
            fi
    
            if [ $? -ne 0 ] ; then
               echo "${file} to ${desthost}:${destdir} at $(date +%Y-%m-%d\ %H:%M)" >> failed_transfers.log &&
               echo "transfer failed. See $(readlink -f failed_transfers.log) for details."
               export success=false
            fi

            remoteuser=$(${proxy} ssh ${desthost} "whoami")
            ${proxy} ssh ${desthost} "chown ${remoteuser}:palaeo-ra ${destdir}/$(basename ${file})" && 
            ${proxy} ssh ${desthost} "chmod 775 ${destdir}/$(basename ${file})"

#         fi # file is not empty
 
      }

      function ypoc_efas {

         # usage: ypoc_efas sourcehost file destdir [overwrite]

         sourcehost=${1}
         file=${2}
         destdir=$(readlink -f ${3})
         overwrite=${4}

         if [ ! -d ${destdir} ]; then
            mkdir --mode=755 -p ${destdir}
         fi  # destdir does not exist


         if $(${proxy} "ssh ${sourcehost} test -e ${file}"); then  # test if file exists on sourcehost

            if [ ! -e ${destdir}/$(basename ${file}) ] || [ "${overwrite}" == "overwrite" ]; then

               ${proxy} rsync ${sourcehost}:${file} ${destdir}/. && echo "${file} copied to ${destdir}/$(basename ${file}) and kept on ${sourcehost}."

               if [ $? -ne 0 ] ; then
                  echo "${sourcehost}:${file} to ${destdir} at $(date +%Y-%m-%d\ %H:%M)" >> failed_transfers.log
                  echo "transfer failed. See $(readlink -f failed_transfers.log) for details."
                  export success=false
               fi

            else

               echo "ERROR: file exists already on desthost. Use overwrite mode to overwrite existing file" && exit 1

            fi # file does not exist on desthost or overwrite is set

         else

            echo "ERROR: file does not exist on sourcehost" && exit 1

         fi # file exists on sourcehost

      }

      ;;

esac

