#!/bin/bash
# a quick and dirty script to rerun the postprocessing in case something failed...
# rhand@giub.unibe.ch, 2019-11-26

set -ex

yearlist=$*

expname=$(pwd | sed -e "s&.*/&&")

for year in ${yearlist}; do
   
   sed -e "s&#DPATH&DPATH=$(pwd)/work&" -e "s/#EXP/EXP=${expname}/" -e "s/#YEAR/YEAR=${year}/" -e "s/#MONTH/MONTH=12/" -e "s/#DAY/DAY=01/"  ${expname}.job1 > work/rerun_subjob1
   sed -e "s&#DPATH&DPATH=$(pwd)/work&" -e "s/#EXP/EXP=${expname}/"  ${expname}.job2 > work/subjob2

   cd work && previousjob=$(sbatch ${dependency} rerun_subjob1 | sed -e "s/Submitted batch job //") && cd -

   dependency="--dependency=afterany:${previousjob}"

done
